--This code has been adapted from SENSEI27's mod: "Auto Med upgrade" https://www.nexusmods.com/cyberpunk2077/mods/2248

------------------------------------------------
-- USER CONFIGURABLE VARIABLES
------------------------------------------------

--Sets the max number of Bounce Back you can have of each tier (completely arbitrary default is: 25 ) 
limitBBmk1 = 25
limitBBmk2 = 25
limitBBmk3 = 25

-- And for Max Doc (completely arbitrary default is: 25 )
limitMDmk1 = 25
limitMDmk2 = 25
limitMDmk3 = 25

showActiveMsg = true	-- Show mod activated message in console
showConvertMsg = true 	-- Show amounts converted in console

useFullWait = true		-- Don't convert until player has stopped picking up things; only used if showConvertMsg = true to show total number converted


-- ADVANCED (recommend to leave at defaults)
autoConvertTime = 4 	-- How often (in sec) to check for items to dismantle  (default: 4)
afterCombatTime = 7		-- Additional time to pause after combat finishes  (default: 7) - (only used if useFullWait = true)
timeFullWait = 17		-- How long to wait after picking up any item  (default: 17)

		-- These are the amount of crafting components that you recive by when disassembling
		-- If you change these you will be getting more components than basgame
aCommon = 3 		--Default 3
aUncommon = 1 		--Default 1
aRare = 1			--Default 1
aEpic =1			--Default 1
aUpgRare = 1		--Default 1
aUpgEpic = 1		--Default 1

------------------------------------------------
-- END OF USER CONFIGUARBLE VARIABLES
------------------------------------------------

------------------------------------------------
-- MAIN CODE
------------------------------------------------
firstRun = true
pauseTime = os.time()
scriptInterval = 0

registerForEvent("onUpdate", function(deltaTime)
------------------------------------------------
-- CHECK GOOD TO GO ...
------------------------------------------------
	if inCombat then
		scriptInterval = (useFullWait and -afterCombatTime) or 0
		return
	end
	if pauseTime > os.time() then
		return
	end
	if notReady() then
		pauseTime = os.time() + 3
		return
	end
	if playerInMenu() then
		pauseTime = os.time() + 3
		return
	end
------------------------------------------------
-- INITIALISE...
------------------------------------------------
	if firstRun then
		firstRun = false
		idBounce1 = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.BonesMcCoy70V0"))
		idBounce2 = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.BonesMcCoy70V1"))
		idBounce3 = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.BonesMcCoy70V2"))
		idDoc1 = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.FirstAidWhiffV0"))
		idDoc2 = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.FirstAidWhiffV1"))
		idDoc3 = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.FirstAidWhiffV2"))

		
		if useFullWait then idToken = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Keycards.test_keycard")) end
		
		if showActiveMsg then print("Auto Med Disassemble activated.") end
	end
	
	if not player then player = Game.GetPlayerSystem():GetLocalPlayerMainGameObject() end
	if not ts then ts = Game.GetTransactionSystem() end
	
	if useFullWait then
		if checkFreeze() then fullWait() return end
		if fullWait(deltaTime) then return end
	end
------------------------------------------------
-- READY...
------------------------------------------------
	scriptInterval = scriptInterval + deltaTime
	if scriptInterval < autoConvertTime then
		return
	else
		scriptInterval = 0
	end
------------------------------------------------
-- GET CURRENT AMOUNTS 
------------------------------------------------
	countBounce1 = ts:GetItemQuantity(player, idBounce1)
	countBounce2 = ts:GetItemQuantity(player, idBounce2)
	countBounce3 = ts:GetItemQuantity(player, idBounce3)
	countDoc1 = ts:GetItemQuantity(player, idDoc1)
	countDoc2 = ts:GetItemQuantity(player, idDoc2)
	countDoc3 = ts:GetItemQuantity(player, idDoc3)
	
	msg = "AutoMedDisassemble: "
	msgFlag = false
	msgFlagMD = false
------------------------------------------------
-- Mk1 BOUNCE BACK UPGRADE
------------------------------------------------
	if countBounce1 >= limitBBmk1 then
		disCount = countBounce1 - limitBBmk1
		
		ts:RemoveItem( player, idBounce1, disCount )

		Game.AddToInventory("Items.CommonMaterial1", aCommon * disCount)
		Game.AddToInventory("Items.UncommonMaterial1", aUncommon * disCount)
		
		msg = msg.."Bounce Back: "..disCount.." Mk1 Disassembled"
		msgFlag = true			
	end
------------------------------------------------
-- Mk2 BOUNCE BACK UPGRADE
------------------------------------------------
	if countBounce2 >= limitBBmk2 then
		disCount = countBounce2 - limitBBmk2
		
		ts:RemoveItem( player, idBounce2, disCount )

		Game.AddToInventory("Items.CommonMaterial1", aCommon * disCount)
		Game.AddToInventory("Items.UncommonMaterial1", aUncommon * disCount)
		Game.AddToInventory("Items.RareMaterial1", aRare * disCount)
		Game.AddToInventory("Items.RareMaterial2", aUpgRare * disCount)

		if msgFlag then
			msg = msg..";  "
		end
		if not msgFlagMD then
			msg = msg.."Bounce Back: "
		end
		msg = msg..disCount.." Mk2 Disassembled"
		msgFlag = true
	end
------------------------------------------------
-- Mk3 BOUNCE BACK DISASSEMBLE
------------------------------------------------
	if countBounce3 >= limitBBmk3 then
		disCount = countBounce3 - limitBBmk3
		
		ts:RemoveItem( player, idBounce3, disCount )

		Game.AddToInventory("Items.CommonMaterial1", aCommon * disCount)
		Game.AddToInventory("Items.UncommonMaterial1", aUncommon * disCount)
		Game.AddToInventory("Items.RareMaterial1", aRare * disCount)
		Game.AddToInventory("Items.RareMaterial2", aUpgRare * disCount)

		if msgFlag then
			msg = msg..";  "
		end
		if not msgFlagMD then
			msg = msg.."Bounce Back: "
		end
		msg = msg..disCount.." Mk3 Disassembled"
		msgFlag = true
	end
------------------------------------------------
-- Mk1 MAXDOC DISASSEMBLE
------------------------------------------------
	if countDoc1 >= limitMDmk1 then
		disCount = countDoc1 - limitMDmk1
		
		ts:RemoveItem( player, idDoc1, disCount )

		Game.AddToInventory("Items.CommonMaterial1", aCommon * disCount)
		Game.AddToInventory("Items.UncommonMaterial1", aUncommon * disCount)

		if msgFlag then
			msg = msg..";  "
		end
		if not msgFlagMD then
			msg = msg.."MaxDoc: "
		end
		msg = msg..disCount.." Mk1 Disassembled"
		msgFlag = true
	end
------------------------------------------------
-- Mk2 MAXDOC DISASSEMBLE
------------------------------------------------
	if countDoc2 >= limitMDmk2 then
		disCount = countDoc2 - limitMDmk2
		
		ts:RemoveItem( player, idDoc2, disCount )

		Game.AddToInventory("Items.CommonMaterial1", aCommon * disCount)
		Game.AddToInventory("Items.UncommonMaterial1", aUncommon * disCount)
		Game.AddToInventory("Items.RareMaterial1", aRare * disCount)
		Game.AddToInventory("Items.RareMaterial2", aUpgRare * disCount)

		if msgFlag then
			msg = msg..";  "
		end
		if not msgFlagMD then
			msg = msg.."MaxDoc: "
		end
		msg = msg..disCount.." Mk2 Disassembled"
		msgFlag = true
	end
------------------------------------------------
-- MK3 MAXDOC DISASSEMBLE
------------------------------------------------
	if countDoc3 >= limitMDmk3 then
		disCount = countDoc3 - limitMDmk3
		
		ts:RemoveItem( player, idDoc3, disCount )

		Game.AddToInventory("Items.CommonMaterial1", aCommon * disCount)
		Game.AddToInventory("Items.UncommonMaterial1", aUncommon * disCount)
		Game.AddToInventory("Items.RareMaterial1", aRare * disCount)
		Game.AddToInventory("Items.EpicMaterial1", aEpic * disCount)
		Game.AddToInventory("Items.RareMaterial2", aUpgRare * disCount)
		Game.AddToInventory("Items.EpicMaterial2", aUpgEpic * disCount)

		if msgFlag then
			msg = msg..";  "
		end
		if not msgFlagMD then
			msg = msg.."MaxDoc: "
		end
		msg = msg..disCount.." Mk3 Disassembled"
		msgFlag = true
	end
------------------------------------------------
	if msgFlag and showConvertMsg then
		print(msg)
	end
------------------------------------------------
end)

------------------------------------------------
-- ADDITIONAL FUNCTIONS
------------------------------------------------
do
	if not showConvertMsg then useFullWait = false end
	local oldInv = 0
	local waitPause = 0
	local itemCashID

	function fullWait(deltaTime)
		if not itemCashID then itemCashID = GetSingleton("gameItemID"):FromTDBID(TweakDBID.new("Items.money")) end
		local currentCash = ts:GetItemQuantity(player, itemCashID)
		
		local currentInv = ts:GetTotalItemQuantity(player) - currentCash
		if oldInv == 0 then oldInv = currentInv end
		
		if currentInv > oldInv then waitPause = timeFullWait end
		oldInv = currentInv
		
		if deltaTime == nil then waitPause = 0; scriptInterval = autoConvertTime; end
		if waitPause > 0 then
			waitPause = waitPause - deltaTime
			return true
		else
			return false
		end

	end
end
------------------------------------------------
-- UTILITY FUNCTIONS
------------------------------------------------
function notReady()
	inkMenuScenario = GetSingleton('inkMenuScenario'):GetSystemRequestsHandler()
	if inkMenuScenario:IsGamePaused() or inkMenuScenario:IsPreGame() then
		return true
	end
	
	if Game.GetPlayerSystem() == nil then
		return true
	end
	
	if Game.GetPlayerSystem():GetLocalPlayerMainGameObject() == nil then
		return true
	end
	
	if Game.GetPlayer() == nil then
		return true
	end

	if Game.GetQuestsSystem():GetFactStr("q000_started") == 0 then
		return true
	end
	
	return false
end

function playerInMenu()
	blackboard = Game.GetBlackboardSystem():Get(Game.GetAllBlackboardDefs().UI_System);
	uiSystemBB = (Game.GetAllBlackboardDefs().UI_System);
	return(blackboard:GetBool(uiSystemBB.IsInMenu));
end

inCombat = false
registerForEvent("onInit", function()
	Observe("PlayerPuppet", "OnCombatStateChanged", function(self,state)
		inCombat = state == 1
	end)
end)

function checkFreeze()
	return ts:GetItemQuantity(player, idToken) > 1
end
